clear all
set matsize 10000
set maxvar 10000
set more off

cd "\IRI data"
	
*** Program to estimate price FE decomposition

	import delimited "iri_rev_sales_private.csv"

	merge m:1 iri_key using entries_wide_11.dta
	drop _merge
	
** Create WM post-entry and entry week indicator
	
	rename wmid* idwm*
	forvalues i=1/19 {
		capture gen wm`i' = (weekid > week`i')
		capture gen enter`i' = (weekid == week`i')
		capture replace dis`i' = 0 if wm`i' == 0
		}
	egen wm = rowtotal(wm*)
	egen enter = rowtotal(enter*)
	
	encode market, gen(mkt)
	
** Setup
	rename iri_key stores
	xtset stores weekid
	
	* Distance spline
	forvalues s=1/1 {
		forvalues i=1/24 {
			capture gen I_`i'_`s' = (dis`i' <= `s' & dis`i' > 0 )
			}
		egen wm_`s' = rowtotal(I_*_`s')
		drop I*
		}

	forvalues s=3(2)11 {
		local s0 = `s'-2
		forvalues i=1/24 {
			capture gen I_`i'_`s' = (dis`i' <= `s' & dis`i' > `s0' )
			}
		egen wm_`s' = rowtotal(I_*_`s')
		drop I*
		}
	
** Merge in store names
	rename stores iri_key
	merge m:1 iri_key using store_names.dta
	drop if _merge == 2
	drop _merge
	rename iri_key stores
	
	* Merge in chain info
	merge m:1 name using chain.dta
	drop _merge
	
	replace firmtype = 3 if firmtype == 4
	gen missing_firmtype = (firmtype == .)
	replace firmtype = 99 if missing_firmtype == 1
	
	gen missing_chain = (chainid ==.)
	encode name, gen(chain)
	replace chain = 0 if missing_chain == 1
	
** Treatment groups
	by stores, sort: egen treat_nwm = max(wm)
	by stores, sort: egen wm0 = min(wm)
	
	gen wm_diff = treat_nwm - wm0
	
** Get FE
	merge m:1 stores using fe.dta
	drop _merge
	
** Load demos
	rename stores iri_key
	merge m:1 iri_key using "store_demos_cat.dta"
	drop if _merge == 2
	drop _merge
	rename iri_key stores
	
	rename inccymedhh medinc
	rename popcydens density
	rename hhdcy n_hh

	foreach var in medinc density {
		gen log`var' = log(`var')
		norm(log`var'), method(zee)
	}
	gen zee_logincdensity = zee_logmedinc*zee_logdensity
	
	xtile inc = medinc, nq(5)
	xtile dens = density, nq(3)
	
** Variables
	foreach var of varlist wm_1-wm_11 {
		by stores, sort: egen treat_`var' = max(`var')
		replace treat_`var' = (treat_`var'>0)
		}

	duplicates drop stores, force
	
	foreach var of varlist *_fe {
		norm(`var'), method(zee)
		}
		
	* Indicator for distance of closest WM
	forvalues i=1/19 {
		capture replace dis`i'=. if wm`i' == 0
		}
	egen min_dis = rowmin(dis*)
	
	forvalues s=1/1 {
		capture gen min_`s' = (min_dis <= `s' & min_dis > 0 )
		}

	forvalues s=3(2)11 {
		local s0 = `s'-2
		capture gen min_`s' = (min_dis <= `s' & min_dis > `s0' )
		}
	
	compress	

	drop if logrev_fe==.

keep stores wm_diff chain mkt firmtype treat_* inc dens n_hh prct* zee* min_* *_fe

** Merge
	save temp.dta, replace
	
	use price_fe.dta, replace
	merge m:1 stores using temp.dta
	drop _merge
	erase temp.dta
	
	foreach var of varlist logp_vol_fe {
		norm(`var'), method(zee) by(cat)
		}
		
	merge m:1 stores category using samplesize.dta
	drop _merge

	* Demean
	foreach var of varlist logp_vol_fe logrev_fe {
		by cat, sort: egen mean_`var' = mean(`var')
		replace `var' = `var' - mean_`var'
		}
		
** Regressions
	cd "\Results"
		
	foreach var of varlist logp_vol_fe {
		reg `var' min_1-min_11 i.cat, cluster(stores)
			outreg2 using final_`var', excel
		reg `var' min_1-min_11 i.mkt i.cat, cluster(stores)
			outreg2 using final_`var', excel
		reg `var' min_1-min_11 i.mkt i.cat if inc~=., cluster(stores)
			outreg2 using final_`var', excel
		reg `var' min_1-min_11 i.inc i.dens i.mkt i.cat, cluster(stores)
			outreg2 using final_`var', excel
		reg `var' min_1-min_11 i.firmtype i.inc i.dens i.mkt i.cat, cluster(stores)
			outreg2 using final_`var', excel
		reg `var' min_1-min_11 i.chain i.inc i.dens i.mkt i.cat, cluster(stores)
			outreg2 using final_`var', excel
		}
		
		
		
		
		